( function( $ ) {

	"use strict";

	// Elementor Editor Popup
	var WprElementorEditorPopup = {

		loaded: false,

		init: function() {
			window.elementor.on( 'preview:loaded', WprElementorEditorPopup.loadPreview );
		},

		loadPreview: function() {
			window.elementorFrontend.hooks.addAction( 'frontend/element_ready/wpr-offcanvas.default', function( $scope ) {
				$scope.find( '.wpr-template-edit-btn' ).on( 'click', WprElementorEditorPopup.renderPopup );
			} );

			window.elementorFrontend.hooks.addAction( 'frontend/element_ready/wpr-elementor-template.default', function( $scope ) {
				$scope.find( '.wpr-template-edit-btn' ).on( 'click', WprElementorEditorPopup.renderPopup );
			} );

			window.elementorFrontend.hooks.addAction( 'frontend/element_ready/shortcode.default', function( $scope ) {
				$scope.find( '.wpr-template-edit-btn' ).on( 'click', WprElementorEditorPopup.renderPopup );
			} );

			window.elementorFrontend.hooks.addAction( 'frontend/element_ready/wpr-advanced-slider.default', function( $scope ) {
				$scope.find( '.wpr-template-edit-btn' ).on( 'click', WprElementorEditorPopup.renderPopup );
			} );

			window.elementorFrontend.hooks.addAction( 'frontend/element_ready/wpr-tabs.default', function( $scope ) {
				$scope.find( '.wpr-template-edit-btn' ).on( 'click', WprElementorEditorPopup.renderPopup );
			} );

			window.elementorFrontend.hooks.addAction( 'frontend/element_ready/wpr-content-toggle.default', function( $scope ) {
				$scope.find( '.wpr-template-edit-btn' ).on( 'click', WprElementorEditorPopup.renderPopup );
			} );

			window.elementorFrontend.hooks.addAction( 'frontend/element_ready/wpr-advanced-accordion.default', function( $scope ) {
				$scope.find( '.wpr-template-edit-btn' ).on( 'click', WprElementorEditorPopup.renderPopup );
			} );
		},

		renderPopup: function( link ) {
			// Open Editor
			WprElementorEditorPopup.getPopup().show();

			// Render Iframe
			$( '#wpr-template-editor-popup .dialog-message').html( '<iframe src="' + $( this ).data( 'permalink' ) + '&elementor' + '" id="wpr-template-edit-frame" width="100%" height="100%"></iframe>' );
			
			// Preloading
			$( '#wpr-template-editor-popup .dialog-message').append( '<div id="wpr-template-editor-loading"><div class="elementor-loader-wrapper"><div class="elementor-loader"><div class="elementor-loader-boxes"><div class="elementor-loader-box"></div><div class="elementor-loader-box"></div><div class="elementor-loader-box"></div><div class="elementor-loader-box"></div></div></div><div class="elementor-loading-title">Loading</div></div></div>' );

			// Loaded
			$( '#wpr-template-edit-frame').on( 'load', function() {
				$( '#wpr-template-editor-loading').fadeOut( 300 );
			} );

			// Close
			$( '#wpr-template-editor-popup .dialog-close-button' ).css({
				'right' : '30px',
				'width' : '35px',
				'height' : '35px',
				'line-height' : '30px',
				'border-radius' : '50%',
				'text-align' : 'center',
				'opacity' : '1',
				'background-color' : '#333',
				'box-shadow' : '1px 1px 3px 0 #000',
			}).html('<i class="eicon-close"></i>');

			$( '#wpr-template-editor-popup .dialog-close-button i' ).css({
				'font-size' : '15px',
				'color' : '#fff',
			})

			$( '#wpr-template-editor-popup .dialog-close-button' ).on( 'click', function() {
				elementor.reloadPreview();
			});
		},

		getPopup: function() {

			if ( ! WprElementorEditorPopup.loaded ) {
				this.loaded = elementor.dialogsManager.createWidget( 'lightbox', {
					id: 'wpr-template-editor-popup',
					closeButton: true,
					hide: { onBackgroundClick: false }
				} );
			}

			return WprElementorEditorPopup.loaded;
		}

	};

	$( window ).on( 'elementor:init', WprElementorEditorPopup.init );


	// Modal Popups
	var WprModalPopups = {

		init: function() {
			if ( ! $( 'body' ).hasClass( 'elementor-editor-wpr-popups' ) ) {
				return;
			}

			// Load Preview
			window.elementor.on( 'preview:loaded', WprModalPopups.onPreviewLoad );

			// Change Preview
			window.elementor.on( 'preview:loaded', WprModalPopups.onPreviewChange );

			// Change Controls
			elementor.settings.page.model.on( 'change', WprModalPopups.onControlChange );
		},

		onPreviewLoad: function() {
			// Open Popup Settings
			setTimeout(function() {
				if ( $( '#elementor-panel-footer-settings' ).length ) {
					$( '#elementor-panel-footer-settings' ).trigger( 'click' );
				} else {
					setTimeout(function() {
						$( '#elementor-panel-footer-settings' ).trigger( 'click' );
					}, 5000);
				}
			}, 2000);

			// Popup Settings Notification
			WprModalPopups.settingsNotification();

			// Fix Popup Layout
			window.elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function( $scope ) {
				var popup = $scope.closest( '.wpr-template-popup' );

				WprModalPopups.fixPopupLayout( popup );
			} );
		},

		onPreviewChange: function() {
			// preview change code goes here
		},

		onControlChange: function( model ) {
			var iframe = document.getElementById( 'elementor-preview-iframe' ),
				iframeContent = iframe.contentDocument || iframe.contentWindow.document;

			// Popup
			var popup = $( '.wpr-template-popup', iframeContent );

			// Scrollbar
			if ( model.changed.hasOwnProperty( 'popup_height' ) ) {
				// elementor.reloadPreview();
			}

			// Display As
			if ( model.changed.hasOwnProperty( 'popup_display_as' ) ) {
				if ( 'notification' === model.changed['popup_display_as'] ) {
					popup.addClass( 'wpr-popup-notification' );
				} else {
					popup.removeClass( 'wpr-popup-notification' );
				}
			}

			if ( model.changed.hasOwnProperty( 'popup_display_as' ) ) {

			}

			// Entrance Animation
			if ( model.changed.hasOwnProperty( 'popup_animation' ) ) {
				var popupContainer = popup.find('.wpr-popup-container');

				popupContainer.removeAttr( 'class');
				popupContainer.addClass( 'wpr-popup-container animated '+ model.changed['popup_animation'] );
			}
		},

		fixPopupLayout: function( popup ) {
			var settings = WprModalPopups.getDocumentSettings();

			// Add Scrollbar
			if ( ! popup.find('.wpr-popup-container-inner').hasClass('ps') ) {
				const ps = new PerfectScrollbar(popup.find('.wpr-popup-container-inner')[0], {
					suppressScrollX: true
				});
			}

			if ( 'notification' === settings.popup_display_as ) {
				popup.addClass( 'wpr-popup-notification' );
			}
		},

		getDocumentSettings: function() {
			var documentSettings = {},
				settings = elementor.settings.page.model;

			jQuery.each(settings.getActiveControls(), function (controlKey) {
				documentSettings[controlKey] = settings.attributes[controlKey];
			});

			return documentSettings;
		},

		settingsNotification: function() {
			var version = $('#wpr-addons-editor-js-js').attr('src');
				version = 'v-'+ version.substring(version .length - 6, version .length);

			// Get Close Time
			var closeTime = JSON.parse( localStorage.getItem( 'WprPopupEditorNotification'+ version) ) || {};

			if ( closeTime + 604800000 >= Date.now() ) {
				return;
			}

			// Notification HTML
			if ( $('body').find('#elementor-editor-wrapper-v2').length > 0 ) {
				// Notification HTML
				var nHTML = '\
					<div id="wpr-template-settings-notification" class="wpr-new-editor-bar">\
						<h4><i class="eicon-info-circle"></i><span>Please Note</span></h4>\
						<p>Click here to access <strong>Popup Settings</strong>.<br>Click our Logo to the bottom to open a <strong>Popup Library</strong>.</p>\
						<i class="eicon-close"></i>\
					</div>\
				';
			} else {
				var nHTML = '\
				<div id="wpr-template-settings-notification">\
					<h4><i class="eicon-info-circle"></i><span>Please Note</span></h4>\
					<p>Click here to access <strong>Popup Settings</strong>.<br>Click our Logo to the right to open a <strong>Popup Library</strong>.</p>\
					<i class="eicon-close"></i>\
				</div>\
			';
			}

			// Render Notification
			if ( $('body').find('#elementor-editor-wrapper-v2').length > 0 ) {
				$('body .MuiBox-root button[value="document-settings"]').append(nHTML).hide().fadeIn();
			} else {
				$( 'body' ).append( nHTML ).hide().fadeIn();
			}

			// Hide on Click
			$( '#wpr-template-settings-notification .eicon-close' ).on( 'click', function() {
				$( '#wpr-template-settings-notification' ).fadeOut();

				// Save Close Time in Browser
				localStorage.setItem( 'WprPopupEditorNotification'+ version, Date.now() );
			});
		},
	};

	$( window ).on( 'elementor:init', WprModalPopups.init );


	// Theme Builder
	var WprThemeBuilder = {

		init: function() {
			if ( ! $( 'body' ).hasClass( 'elementor-editor-wpr-theme-builder' ) ) {
				return;
			}

			// Load Preview
			window.elementor.on( 'preview:loaded', WprThemeBuilder.onPreviewLoad );
		},

		onPreviewLoad: function() {

			// Popup Settings Notification
			WprThemeBuilder.settingsNotification();

			// Submit Preview Changes
			$( '#elementor-panel-footer-settings' ).on( 'click', function() {
				setTimeout(function() {
					$( '.elementor-control-submit_preview_changes button' ).on( 'click', function() {
						$e.run('document/save/auto', {
						force: true,
							onSuccess: function onSuccess() {
								elementor.reloadPreview();
								elementor.once('preview:loaded', function () {
									$e.route('panel/page-settings/settings');
								});
							}
						});
					});
				}, 500);
			});

		},

		settingsNotification: function() {
			var version = $('#wpr-addons-editor-js-js').attr('src');
				version = 'v-'+ version.substring(version .length - 6, version .length);

			// Get Close Time
			var closeTime = JSON.parse( localStorage.getItem('WprThemeBuilderNotification'+ version) ) || {};

			if ( closeTime + 604800000 >= Date.now() ) {
				return;
			}

			if ( $('body').find('#elementor-editor-wrapper-v2').length > 0 ) {
				// Notification HTML
				var nHTML = '\
					<div id="wpr-template-settings-notification" class="wpr-new-editor-bar">\
						<h4><i class="eicon-info-circle"></i><span>Please Note</span></h4>\
						<p>You can change <strong>Preview Settings</strong> here.</p>\
						<i class="eicon-close"></i>\
					</div>\
				';
			} else {
				// Notification HTML
				var nHTML = '\
					<div id="wpr-template-settings-notification">\
						<h4><i class="eicon-info-circle"></i><span>Please Note</span></h4>\
						<p>You can change <strong>Preview Settings</strong> here.</p>\
						<i class="eicon-close"></i>\
					</div>\
				';
			}

			setTimeout(function() {
				// Render Notification
				if ( !$('#wpr-template-settings-notification').length ) {
					if ( $('body').find('#elementor-editor-wrapper-v2').length > 0 ) {
						$('body .MuiBox-root button[value="document-settings"]').append(nHTML).hide().fadeIn();
					} else {
						$('body').append(nHTML).hide().fadeIn();
					}

					// Set Close Time
					$(document).on( 'click', function() {
						$('#wpr-template-settings-notification').fadeOut();
					});

					// Hide on Click
					$('#wpr-template-settings-notification .eicon-close').on( 'click', function() {
						$( '#wpr-template-settings-notification' ).fadeOut();

						// Save Close Time in Browser
						localStorage.setItem( 'WprThemeBuilderNotification'+ version, Date.now() );
					});
				}
			}, 1000 );
		},
	};

	$( window ).on( 'elementor:init', WprThemeBuilder.init );
    
    // Sticky Section Editor JS
    $(window).on('elementor:init', function () {
		elementor.settings.page.addChangeCallback( 'wpr_rpb_enable', function ( newValue ) {
            if('yes' == newValue ) {
                let wrpbHtml = '<div class="wpr-reading-progress-bar-container"><div class="wpr-reading-progress-bar wpr-mybar" id="wpr-mybar"></div></div>';
                $( elementorFrontend.elements.$body ).append( wrpbHtml );
            } else {
                if ( $( elementorFrontend.elements.$body ).find( '.wpr-reading-progress-bar-container' ).length ) {
                    $( elementorFrontend.elements.$body ).find( '.wpr-reading-progress-bar-container' ).remove();
                }
            }
        });
	});

	$(window).on('elementor:init', function () {
		// Data Table
		elementor.hooks.addAction( 'panel/open_editor/widget/wpr-data-table', function( panel, model, view ) {
			elementor.channels.editor.on( 'my-table-export',() => {
				
				console.log('table exporting');
				// var html = view.$el.find('.wpr-data-table');
				var html = view.$el.find('.wpr-data-table').prop('outerHTML');
				htmlToCSV(html, "placeholder.csv", view);
			} );
		});
	});

	function htmlToCSV(html, filename, view) {
		var data = [];
		var rows = view.$el.find('.wpr-data-table').find(".wpr-table-row");
				
		for (var i = 0; i < rows.length; i++) {
			var row = [], cols = rows[i].querySelectorAll(".wpr-table-text");
					
			for (var j = 0; j < cols.length; j++) {
					row.push(cols[j].innerText);
			}
			
			data.push(row.join(",")); 		
		}
	
		downloadCSVFile(data.join("\n"), filename);
	}

	function downloadCSVFile(csv, filename) {
		var csv_file, download_link;
	
		csv_file = new Blob([csv], {type: "text/csv"});
	
		download_link = document.createElement("a");
	
		download_link.download = filename;
	
		download_link.href = window.URL.createObjectURL(csv_file);
	
		download_link.style.display = "none";
	
		document.body.appendChild(download_link);
	
		download_link.click();
	} // Data Table CSV export

}( jQuery ) );

function connectInstagramInit(obj) {

    if (!obj) return;

    var type = jQuery(obj).data("type");

	console.log(type);

    connectInstagram(obj, type);
}

// $( window ).on( 'elementor:init', function() {
	
// 	$('.wpr-facebook-login').on('click',  connectInstagramInit);

// 	function connectInstagramInit(obj) {

// 		if (!obj) return;

// 		var type = jQuery(obj).data("type");

// 		console.log(obj);

// 		connectInstagram(obj, type);
// 	}
// } );